# -*- makefile -*-
#########################################################################
#
# makefile for Documents of The Hessling Editor (THE)
#
# needs:
# THE (with REXX-support)
# REXX-interpreter
# manext       to extract the docs as text from the source files
# man2html.rex (modified) to convert the text docs to html docs
# tocol.the    to help building a 5-coulumn-TOC for large files
# echo, ln, rm, sed, grep, cat, head for reorganizing the HTML-docs
#
# changes
# 13-Feb 2000 (fjw): adopted for version 3.0, additional appendix and
#                    additional option html_ext
# 03-Jun 1999 (fjw): glossary items are listed in a five column table too
#
#########################################################################

VER = 30
VER_DOT=3.0
THE_DIR=THE-3.0

#########################################################################
# change these to your needs
srcdir	  = g:/src/$(THE_DIR)
docdir	  = $(srcdir)/doc
#html_ext  = .html
html_ext  = .htm

# OS/2: use .cmd
#MAN2HTML = man2html.cmd
#REXX     =

# other: use .rex and specify REXX-Interpreter
MAN2HTML = man2html.rex
REXX = rexx
#REXX = Regina

# OS/2, WIN32: use .exe, else use no extension
MAN=manext.exe

#########################################################################
#
COMMSTD = \
	$(srcdir)/comm1.c \
	$(srcdir)/comm2.c \
	$(srcdir)/comm3.c \
	$(srcdir)/comm4.c \
	$(srcdir)/comm5.c
COMMSOS = \
	$(srcdir)/commsos.c 
COMMSET = \
	$(srcdir)/commset1.c \
	$(srcdir)/commset2.c

QUERY = $(srcdir)/query.c

COMMANDS = $(COMMSTD) $(COMMSOS) $(COMMSET)

COMM = $(COMMANDS) $(QUERY)

APPENDIX1 = $(srcdir)/appendix.1 
APPENDIX2 = $(srcdir)/appendix.2
APPENDIX3 = $(srcdir)/appendix.3
APPENDIX4 = $(srcdir)/appendix.4
APPENDIX = $(APPENDIX1) $(APPENDIX2) $(APPENDIX3) $(APPENDIX4)

OVERVIEW = $(srcdir)/overview
GLOSSARY = $(srcdir)/glossary

ALLMAN = overview.man comm.man commset.man commsos.man query.man app1.man app2.man app3.man app4.man glossary.man
#
#########################################################################
all:	manual html help

clean: cleandoc

cleandoc: 
	rm -f THE_help.txt *$(html_ext) *.tmp *.man THE_Help*

#########################################################################
# ASCII Manual
manual:	$(ALLMAN)
	cat $(ALLMAN) > the.man
#########################################################################
#overview.man: $(OVERVIEW)
overview.man: $(MAN) $(OVERVIEW)
	./manext $(OVERVIEW)>overview.man

comm.man: $(COMMSTD) $(MAN)
	./manext $(COMMSTD) > comm.man 

commset.man: $(MAN) $(COMMSET)
	./manext $(COMMSET) > commset.man 
commsos.man: $(MAN) $(COMMSOS)
	./manext $(COMMSOS) > commsos.man 
query.man: $(MAN) $(QUERY)
	./manext $(QUERY) > query.man
glossary.man: $(MAN) $(GLOSSARY)
	./manext $(GLOSSARY) > glossary.man
app1.man: $(MAN) $(APPENDIX1)
	./manext $(APPENDIX1) > app1.man
app2.man: $(MAN) $(APPENDIX2)
	./manext $(APPENDIX2) > app2.man
app3.man: $(MAN) $(APPENDIX3)
	./manext $(APPENDIX3) > app3.man
app4.man: $(MAN) $(APPENDIX4)
	./manext $(APPENDIX4) > app4.man
history.man: $(srcdir)/HISTORY
	cp $(srcdir)/HISTORY history.man

#########################################################################
# ASCII Quick Reference
quickref.man: THE_Help.txt
	ln THE_Help.txt quickref.man

help: THE_Help.txt

THE_Help.txt: $(MAN) $(docdir)/THE_Help_head THE_Help_part04 $(docdir)/THE_Help_set THE_Help_part06 $(docdir)/THE_Help_sos THE_Help_part08 $(docdir)/THE_Help_tail
	echo                          THE Quick Reference > THE_Help_part01
	echo                              Version $(VER_DOT) > THE_Help_part02
	ln $(docdir)/THE_Help_head THE_Help_part03
	ln $(docdir)/THE_Help_set  THE_Help_part05
	ln $(docdir)/THE_Help_sos  THE_Help_part07
	ln $(docdir)/THE_Help_tail THE_Help_part09
	cat THE_Help_part?? > THE_Help.txt

THE_Help_part04: $(COMMSTD) 
	manext -q $(COMMSTD) > THE_Help_part04

THE_Help_part06: $(COMMSET) 
	manext -q $(COMMSET) > THE_Help_part06

THE_Help_part08: $(COMMSOS)
	manext -q $(COMMSOS) > THE_Help_part08

#########################################################################
# HTML manual
htm: html

html: index$(html_ext)

index.html: index.htm

index.htm: $(MAN2HTML) overview$(html_ext) comm$(html_ext) commset$(html_ext) commsos$(html_ext) query$(html_ext) glossary$(html_ext) app1$(html_ext) app2$(html_ext) app3$(html_ext) app4$(html_ext) app5$(html_ext) app6$(html_ext) history$(html_ext) quickref$(html_ext)
	$(REXX) $(MAN2HTML) $(html_ext) $(VER_DOT) TOCSTART  >index$(html_ext)
	cat     ioverview.tmp         >>index$(html_ext)
	head -1 icomm.tmp             >>index$(html_ext)
	head -1 icommset.tmp          >>index$(html_ext)
	head -1 icommsos.tmp          >>index$(html_ext)
	cat     iquery.tmp            >>index$(html_ext)
	cat     igloss.tmp            >>index$(html_ext)
	cat     iapp1.tmp             >>index$(html_ext)
	cat     iapp2.tmp             >>index$(html_ext)
	cat     iapp3.tmp             >>index$(html_ext)
	cat     iapp4.tmp             >>index$(html_ext)
	cat     iapp5.tmp             >>index$(html_ext)
	cat     iapp6.tmp             >>index$(html_ext)
	head -1 ihistory.tmp          >>index$(html_ext)
	cat     iquickref.tmp         >>index$(html_ext)
	$(REXX) $(MAN2HTML) $(html_ext) $(VER_DOT) TOCEND    >>index$(html_ext)

overview.html: overview.htm

overview.htm: $(MAN2HTML) overview.man
	rm -f ioverview.tmp overview$(html_ext)
	$(REXX) $(MAN2HTML) $(html_ext) $(VER_DOT) OVERVIEW  overview.man ioverview.tmp >overview$(html_ext)

comm.html: comm.htm

comm.htm: $(MAN2HTML) comm.man
	rm -f icomm.tmp tcomm.tmp
	$(REXX) $(MAN2HTML) $(html_ext) $(VER_DOT) COMM      comm.man     icomm.tmp    >tcomm.tmp
	sed -e "1d" icomm.tmp>mcomm.tmp
	head -7 tcomm.tmp>hcomm.tmp
	sed -e "1,7d" tcomm.tmp>ecomm.tmp
	cat hcomm.tmp    mcomm.tmp    ecomm.tmp      >comm$(html_ext)

commset.html: commsos.htm

commset.htm: $(MAN2HTML) commset.man
	rm -f icommset.tmp tcommset.tmp
	$(REXX) $(MAN2HTML) $(html_ext) $(VER_DOT) COMMSET   commset.man  icommset.tmp >tcommset.tmp
	sed -e "1d" icommset.tmp>mcommset.tmp
	head -7 tcommset.tmp>hcommset.tmp
	sed -e "1,7d" tcommset.tmp>ecommset.tmp
	cat hcommset.tmp mcommset.tmp ecommset.tmp   >commset$(html_ext)

commsos.html: commsos.htm

commsos.htm: $(MAN2HTML) commsos.man
	rm -f icommsos.tmp tcommsos.tmp
	$(REXX) $(MAN2HTML) $(html_ext) $(VER_DOT) COMMSOS   commsos.man  icommsos.tmp >tcommsos.tmp
	sed -e "1d" icommsos.tmp>mcommsos.tmp
	head -7 tcommsos.tmp>hcommsos.tmp
	sed -e "1,7d" tcommsos.tmp>ecommsos.tmp
	cat hcommsos.tmp mcommsos.tmp ecommsos.tmp   >commsos$(html_ext)

query.html: query.htm

query.htm: $(MAN2HTML) query.man
	rm -f query.tmp query?.tmp ?query.tmp
	$(REXX) $(MAN2HTML) $(html_ext) $(VER_DOT) QUERY     query.man    xquery.tmp    >1query.tmp
	grep -e '^.DT..A' xquery.tmp >iquery.tmp
	sed -n -e "5,7d" -e "1,/^.HR..DL/p" 1query.tmp>query1.tmp
	sed -e "1,/^.HR..DL/d" 1query.tmp>3query.tmp
	grep "^.A .*#[A-Z]*.. [A-Z]" xquery.tmp >2query.tmp
	the -b -p $(docdir)/tocol.the -a query2.tmp 2query.tmp
	sed -n -e "1,/^.HR..DL/p" 3query.tmp>query3.tmp
	sed -e "1,/^.HR..DL/d" 3query.tmp>4query.tmp
	sed -n -e "1,/^.HR..DL/p" 4query.tmp>query4.tmp
	sed -e "1,/^.HR..DL/d" 4query.tmp>6query.tmp
	grep "^.A .*#[A-Z]*()" xquery.tmp >5query.tmp
	the -b -p $(docdir)/tocol.the -a query5.tmp 5query.tmp
	sed -n -e "1,/^.HR..DL/p" 6query.tmp>query6.tmp
	sed -e "1,/^.HR..DL/d" 6query.tmp>query8.tmp
	grep "^.A .*#[A-Z_]*([A-Z]" xquery.tmp >query7.tmp
	cat query?.tmp > query$(html_ext)

glossary.html: glossary.htm

glossary.htm: $(MAN2HTML) glossary.man
	rm -f xgloss.tmp tgloss.tmp
	$(REXX) $(MAN2HTML) $(html_ext) $(VER_DOT) GLOSSARY  glossary.man xgloss.tmp   >tgloss.tmp
	sed -e "1d" xgloss.tmp>ygloss.tmp
	head -1 ygloss.tmp>igloss.tmp
	sed -e "1d" ygloss.tmp>zgloss.tmp
	the -b -p $(docdir)/tocol.the -a mgloss.tmp zgloss.tmp
	head -8 tgloss.tmp       >hgloss.tmp
	sed -e "1,8d" tgloss.tmp >egloss.tmp
	cat hgloss.tmp mgloss.tmp egloss.tmp         >glossary$(html_ext)

app1.html: app1.htm

app1.htm: $(MAN2HTML) app1.man
	rm -f iapp1.tmp app1$(html_ext)
	$(REXX) $(MAN2HTML) $(html_ext) $(VER_DOT) APPENDIX1 app1.man     iapp1.tmp    >app1$(html_ext)

app2.html: app2.htm

app2.htm: $(MAN2HTML) app2.man
	rm -f iapp2.tmp app2$(html_ext)
	$(REXX) $(MAN2HTML) $(html_ext) $(VER_DOT) APPENDIX2 app2.man     iapp2.tmp    >app2$(html_ext)

app3.html: app3.htm

app3.htm: $(MAN2HTML) app3.man
	rm -f iapp3.tmp app3$(html_ext)
	$(REXX) $(MAN2HTML) $(html_ext) $(VER_DOT) APPENDIX3 app3.man     iapp3.tmp    >app3$(html_ext)

app4.html: app4.htm

app4.htm: $(MAN2HTML) app4.man
	rm -f iapp4.tmp app4$(html_ext)
	$(REXX) $(MAN2HTML) $(html_ext) $(VER_DOT) APPENDIX4 app4.man     iapp4.tmp    >app4$(html_ext)

# for these appendices there's no .man file
app5.html: app5.htm

app5.htm: $(MAN2HTML) $(docdir)/app5.htm
	rm -f app5$(html_ext) iapp5.tmp
	$(REXX) $(MAN2HTML) $(html_ext) $(VER_DOT) APPENDIX5 $(docdir)/app5.htm iapp5.tmp > app5$(html_ext)

app6.html: app6.htm

app6.htm: $(MAN2HTML) $(docdir)/app6.htm
	rm -f app6$(html_ext) iapp6.tmp
	$(REXX) $(MAN2HTML) $(html_ext) $(VER_DOT) APPENDIX6 $(docdir)/app6.htm iapp6.tmp > app6$(html_ext)

history.html: history.htm

history.htm: $(MAN2HTML) history.man
	rm -f history$(html_ext) ihistory.tmp
	$(REXX) $(MAN2HTML) $(html_ext) $(VER_DOT) HISTORY history.man ihistory.tmp > thistory.tmp
	sed -e "1d" ihistory.tmp>mhistory.tmp
	head -6 thistory.tmp>hhistory.tmp
	sed -e "1,6d" thistory.tmp>ehistory.tmp
	cat hhistory.tmp    mhistory.tmp    ehistory.tmp      >history$(html_ext)

quickref.html: quickref.htm

quickref.htm: $(MAN2HTML) quickref.man
	rm -f iquickref.tmp quickref$(html_ext)
	$(REXX) $(MAN2HTML) $(html_ext) $(VER_DOT) QUICKREF quickref.man iquickref.tmp > quickref$(html_ext)

$(MAN2HTML): $(srcdir)/$(MAN2HTML)
	echo $(srcdir)/$(MAN2HTML) is newer than $(MAN2HTML)
	ls -l $(srcdir)/$(MAN2HTML) $(MAN2HTML)
#	ln $(srcdir)/man2html.rex $(MAN2HTML)
